%This is a block of code that solves the model

%These are the initial conditions used in all simulations starting on Feb
%15 2020
E0 = 33/population;
Ev0 = 0;
S0 = (1-E0);
I0 = 0;
Iv0 = 0;
R0 = 0;
H0 = 0;
D0 = 0;


y0 = zeros(8,1);
params = zeros(18,1);

params(1) =betabar;
params(2) = kappa ;
params(3) = zeta ;
params(4) = gamma;
params(5) = sigma ;
params(6) = eta;
params(7) = nu;
params(8) = seasonalsize;
params(9) = fatiguesize;
params(10) = fatiguemean;
params(11) = fatiguesig;
params(12) = betabarv;
params(13) = tv;
params(14) = Evbar;
params(15) = seasonalposition;
params(16) = lambda;
params(17) = xi;
params(18) = mitigate;

y0(1) = S0;
y0(2) = E0;
y0(3) = Ev0;
y0(4) = I0;
y0(5) = Iv0;
y0(6) = R0;
y0(7) = H0;
y0(8) = D0;

opts = odeset('Reltol',1e-13,'AbsTol',1e-14,'Stats','on');
[t1,y1] = ode113(@(t,y) bpeaodefile(t,y,params),[t0 tfinal],y0,opts);

S1 = y1(:,1);
E1 = y1(:,2);
Ev1 = y1(:,3);
I1 = y1(:,4);
Iv1 = y1(:,5);
R1 = y1(:,6);
H1 = y1(:,7);
D1 = y1(:,8);
Ddot1 = nu*zeta*(eta*gamma*(I1+Iv1) - zeta*H1);
gD1 = Ddot1./(nu.*zeta.*H1);